# 有效的数独
<p>请你判断一个 <code>9x9</code> 的数独是否有效。只需要<strong> 根据以下规则</strong> ，验证已经填入的数字是否有效即可。</p>
<ol>
    <li>数字 <code>1-9</code> 在每一行只能出现一次。</li>
    <li>数字 <code>1-9</code> 在每一列只能出现一次。</li>
    <li>数字 <code>1-9</code> 在每一个以粗实线分隔的 <code>3x3</code> 宫内只能出现一次。（请参考示例图）</li>
</ol>
<p>数独部分空格内已填入了数字，空白格用 <code>'.'</code> 表示。</p>
<p><strong>注意：</strong></p>
<ul>
    <li>一个有效的数独（部分已被填充）不一定是可解的。</li>
    <li>只需要根据以上规则，验证已经填入的数字是否有效即可。</li>
</ul>
<p> </p>
<p><strong>示例 1：</strong></p><img
    src="https://cdn.jsdelivr.net/gh/doocs/leetcode@main/solution/0000-0099/0036.Valid%20Sudoku/images/250px-sudoku-by-l2g-20050714svg.png"
    style="height:250px; width:250px" />
<pre><strong>输入：</strong>board = 
    [["5","3",".",".","7",".",".",".","."]
    ,["6",".",".","1","9","5",".",".","."]
    ,[".","9","8",".",".",".",".","6","."]
    ,["8",".",".",".","6",".",".",".","3"]
    ,["4",".",".","8",".","3",".",".","1"]
    ,["7",".",".",".","2",".",".",".","6"]
    ,[".","6",".",".",".",".","2","8","."]
    ,[".",".",".","4","1","9",".",".","5"]
    ,[".",".",".",".","8",".",".","7","9"]]
<strong><br />输出：</strong>true
</pre>
<p><strong>示例 2：</strong></p>
<pre><strong>输入：</strong>board = 
    [["8","3",".",".","7",".",".",".","."]
    ,["6",".",".","1","9","5",".",".","."]
    ,[".","9","8",".",".",".",".","6","."]
    ,["8",".",".",".","6",".",".",".","3"]
    ,["4",".",".","8",".","3",".",".","1"]
    ,["7",".",".",".","2",".",".",".","6"]
    ,[".","6",".",".",".",".","2","8","."]
    ,[".",".",".","4","1","9",".",".","5"]
    ,[".",".",".",".","8",".",".","7","9"]]
<strong><br />输出：</strong>false
<strong><br />解释：</strong>除了第一行的第一个数字从<strong> 5</strong> 改为 <strong>8 </strong>以外，空格内其他数字均与 示例1 相同。 但由于位于左上角的 3x3 宫内有两个 8 存在, 因此这个数独是无效的。</pre>
<p> </p>
<p><strong>提示：</strong></p>
<ul>
    <li><code>board.length == 9</code></li>
    <li><code>board[i].length == 9</code></li>
    <li><code>board[i][j]</code> 是一位数字或者 <code>'.'</code></li>
</ul>
<p>以下错误的选项是？</p>
## aop
### before
```cpp

```
### after
```cpp

```

## 答案
```cpp
class Solution
{
public:
    bool isValidSudoku(vector<vector<char>> &board)
    {

        int rule1[10][10] = {0}, rule2[10][10] = {0}, rule3[10][10] = {0};
        for (int row = 0; row < 9; row++)
        {
            for (int col = 0; col < 9; col++)
            {
                if (board[row][col] >= '0' && board[row][col] <= '9')
                {
                    rule1[row][board[row][col] - '0']++;
                    if (rule1[row][board[row][col] - '0'] > 1)
                        return false;
                    rule2[board[row][col] - '0'][col]++;
                    if (rule2[board[row][col] - '0'][col] > 1)
                        return false;
                    int name = row / 3 + (col % 3) * 3;
                    rule3[name][board[row][col] - '0']++;
                    if (rule3[name][board[row][col] - '0'] > 1)
                        return false;
                }
            }
        }
        return true;
    }
};
```
## 选项

### A
```cpp
class Solution
{
public:
    bool isValidSudoku(vector<vector<char>> &board)
    {
        for (int i = 0; i < board.size(); i++)
        {
            vector<bool> mark(10);
            for (int j = 0; j < board.size(); j++)
            {
                if (!valid(board, mark, i, j))
                {
                    return false;
                }
            }
        }
        for (int j = 0; j < board.size(); j++)
        {
            vector<bool> mark(10);
            for (int i = 0; i < board.size(); i++)
            {
                if (!valid(board, mark, i, j))
                {
                    return false;
                }
            }
        }
        for (int k = 0; k < board.size(); k++)
        {
            int sr = k / 3 * 3;
            int sc = (k % 3) * 3;
            vector<bool> mark(10);
            for (int i = sr; i < sr + 3; i++)
            {
                for (int j = sc; j < sc + 3; j++)
                {
                    if (!valid(board, mark, i, j))
                    {
                        return false;
                    }
                }
            }
        }
        return true;
    }

private:
    bool valid(vector<vector<char>> &board, vector<bool> &mark, int i, int j)
    {
        if (board[i][j] != '.')
        {
            int index = board[i][j] - '0';
            if (mark[index])
            {
                return false;
            }
            else
            {
                mark[index] = 1;
            }
        }
        return true;
    }
};
```

### B
```cpp
class Solution
{
public:
    bool isValidSudoku(vector<vector<char>> &board)
    {
        int len = 9;

        for (int i = 0; i < len; ++i)
        {
            if (isRowValid(i, board) == false)
                return false;
        }

        for (int i = 0; i < len; ++i)
        {
            if (isColumnValid(i, board) == false)
                return false;
        }

        for (int i = 0; i < len; i += 3)
        {
            for (int j = 0; j < len; j += 3)
            {
                if (isNineValid(i, j, board) == false)
                    return false;
            }
        }
        return true;
    }

    bool isRowValid(int row, vector<vector<char>> &board)
    {
        vector<char> temp;
        for (int i = 0; i < board[0].size(); ++i)
        {
            if ('.' == board[row][i])
                continue;
            else
            {
                temp.push_back(board[row][i]);
            }
            for (int j = 0; j < temp.size() - 1; ++j)
            {
                if (temp[j] == board[row][i])
                    return false;
            }
        }
        return true;
    }

    bool isColumnValid(int column, vector<vector<char>> &board)
    {
        vector<char> temp;
        for (int i = 0; i < board[0].size(); ++i)
        {
            if (board[i][column] == '.')
                continue;
            else
            {
                temp.push_back(board[i][column]);
            }
            for (int j = 0; j < temp.size() - 1; ++j)
            {
                if (temp[j] == board[i][column])
                    return false;
            }
        }
        return true;
    }

    bool isNineValid(int row, int column, vector<vector<char>> &board)
    {
        vector<char> temp;
        for (int i = row; i < row + 3; ++i)
        {
            for (int j = column; j < column + 3; ++j)
            {
                if (board[i][j] == '.')
                    continue;
                else
                {
                    temp.push_back(board[i][j]);
                }
                for (int k = 0; k < temp.size() - 1; ++k)
                {
                    if (temp[k] == board[i][j])
                        return false;
                }
            }
        }
        return true;
    }
};
```

### C
```cpp
class Solution
{
public:
    bool isValidSudoku(vector<vector<char>> &board)
    {
        vector<vector<bool>> rows(9, vector<bool>(9, false));
        vector<vector<bool>> cols(9, vector<bool>(9, false));
        vector<vector<bool>> blocks(9, vector<bool>(9, false));

        for (int i = 0; i < 9; ++i)
        {
            for (int j = 0; j < 9; ++j)
            {
                if (board[i][j] == '.')
                    continue;
                int c = board[i][j] - '1';
                if (rows[i][c] || cols[j][c] || blocks[i - i % 3 + j / 3][c])
                    return false;
                rows[i][c] = cols[j][c] = blocks[i - i % 3 + j / 3][c] = true;
            }
        }
        return true;
    }
};
```
